/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExceptionsKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Join;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TableKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.UpdateBuilder;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0006\u0010\u001b\u001a\u00020\u001a\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002\u0012\u0010\b\u0002\u0010!\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001f\u00a2\u0006\u0004\b%\u0010&J)\u0010\u0007\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00040\u00030\u0003H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u000f\u001a\u00020\u0002*\u00020\u000e2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R,\u0010\u0015\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00040\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0016\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001b\u001a\u00020\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001f\u0010!\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001f8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\u00a8\u0006'"}, d2={"Lorg/jetbrains/exposed/sql/statements/UpdateStatement;", "Lorg/jetbrains/exposed/sql/statements/UpdateBuilder;", "", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/IColumnType;", "", "arguments", "()Ljava/lang/Iterable;", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "", "prepareSQL", "(Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "executeInternal", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Integer;", "", "Lorg/jetbrains/exposed/sql/Column;", "getFirstDataSet", "()Ljava/util/List;", "firstDataSet", "limit", "Ljava/lang/Integer;", "getLimit", "()Ljava/lang/Integer;", "Lorg/jetbrains/exposed/sql/ColumnSet;", "targetsSet", "Lorg/jetbrains/exposed/sql/ColumnSet;", "getTargetsSet", "()Lorg/jetbrains/exposed/sql/ColumnSet;", "Lorg/jetbrains/exposed/sql/Op;", "", "where", "Lorg/jetbrains/exposed/sql/Op;", "getWhere", "()Lorg/jetbrains/exposed/sql/Op;", "<init>", "(Lorg/jetbrains/exposed/sql/ColumnSet;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;)V", "exposed-core"})
public class UpdateStatement
extends UpdateBuilder<Integer> {
    @NotNull
    private final ColumnSet targetsSet;
    @Nullable
    private final Integer limit;
    @Nullable
    private final Op<Boolean> where;

    public UpdateStatement(@NotNull ColumnSet targetsSet, @Nullable Integer limit, @Nullable Op<Boolean> where) {
        Intrinsics.checkNotNullParameter((Object)targetsSet, (String)"targetsSet");
        super(StatementType.UPDATE, TableKt.targetTables(targetsSet));
        this.targetsSet = targetsSet;
        this.limit = limit;
        this.where = where;
    }

    public /* synthetic */ UpdateStatement(ColumnSet columnSet, Integer n, Op op, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            op = null;
        }
        this(columnSet, n, op);
    }

    @NotNull
    public final ColumnSet getTargetsSet() {
        return this.targetsSet;
    }

    @Nullable
    public final Integer getLimit() {
        return this.limit;
    }

    @Nullable
    public final Op<Boolean> getWhere() {
        return this.where;
    }

    @NotNull
    public List<Pair<Column<?>, Object>> getFirstDataSet() {
        return MapsKt.toList(this.getValues());
    }

    @Override
    @NotNull
    public Integer executeInternal(@NotNull PreparedStatementApi $this$executeInternal, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)$this$executeInternal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        if (this.getValues().isEmpty()) {
            return 0;
        }
        return $this$executeInternal.executeUpdate();
    }

    @Override
    @NotNull
    public String prepareSQL(@NotNull Transaction transaction2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        if (!(!((Collection)this.getFirstDataSet()).isEmpty())) {
            boolean bl = false;
            String string2 = "Can't prepare UPDATE statement without fields to update";
            throw new IllegalArgumentException(string2.toString());
        }
        ColumnSet columnSet = this.targetsSet;
        if (columnSet instanceof Table) {
            string = transaction2.getDb().getDialect().getFunctionProvider().update((Table)this.targetsSet, this.getFirstDataSet(), this.limit, this.where, transaction2);
        } else if (columnSet instanceof Join) {
            string = transaction2.getDb().getDialect().getFunctionProvider().update((Join)this.targetsSet, this.getFirstDataSet(), this.limit, this.where, transaction2);
        } else {
            ExceptionsKt.throwUnsupportedException(transaction2, "UPDATE with " + Reflection.getOrCreateKotlinClass(this.targetsSet.getClass()).getSimpleName() + " unsupported");
            throw new KotlinNothingValueException();
        }
        return string;
    }

    @Override
    @NotNull
    public Iterable<Iterable<Pair<IColumnType, Object>>> arguments() {
        QueryBuilder $this$arguments_u24lambda_u2d2 = new QueryBuilder(true);
        boolean bl = false;
        Map<Column<?>, Object> $this$forEach$iv = this.getValues();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Column<?>, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Column<?>, Object> element$iv;
            Map.Entry<Column<?>, Object> it = element$iv = iterator2.next();
            boolean bl2 = false;
            $this$arguments_u24lambda_u2d2.registerArgument(it.getKey(), it.getValue());
        }
        Op<Boolean> op = this.getWhere();
        if (op != null) {
            op.toQueryBuilder($this$arguments_u24lambda_u2d2);
        }
        return !((Collection)$this$arguments_u24lambda_u2d2.getArgs()).isEmpty() ? CollectionsKt.listOf($this$arguments_u24lambda_u2d2.getArgs()) : CollectionsKt.emptyList();
    }
}

